<?php
namespace Codexpert\CoDesigner_Pro;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Codexpert\CoDesigner\App\Controls\Group_Control_Gradient_Text;
use Elementor\Repeater;

class Filter_Advance extends Widget_Base {

	public $id;

	public function __construct( $data = [], $args = null ) {
	    parent::__construct( $data, $args );

	    $this->id = wcd_get_widget_id( __CLASS__ );
	    $this->widget = wcd_get_widget( $this->id );
	    
		// Are we in debug mode?
		$min = defined( 'CODESIGNER_PRO_DEBUG' ) && CODESIGNER_PRO_DEBUG ? '' : '.min';

		wp_register_style( "codesigner-{$this->id}", plugins_url( "assets/css/style{$min}.css", __FILE__ ), [], '1.1' );

		wp_enqueue_script( 'jquery-ui-slider' );
	}

	public function get_script_depends() {
		return [ "codesigner-{$this->id}" ];
	}

	public function get_style_depends() {
		return [ "codesigner-{$this->id}" ];
	}

	public function get_name() {
		return $this->id;
	}

	public function get_title() {
		return $this->widget['title'];
	}

	public function get_icon() {
		return $this->widget['icon'];
	}

	public function get_categories() {
		return $this->widget['categories'];
	}

	protected function register_controls() {

		/**
		 * Settings controls
		 */
		$this->start_controls_section(
			'fv_general',
			[
				'label' 		=> __( 'Components', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'taxonomy_repeater_name', [
				'label' 		=> __( 'Name', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'taxonomy_show', [
				'label' 		=> __( 'Show in Filter', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SWITCHER,
			]
		);

		$repeater->add_control(
			'taxonomy_repeater_select',
			[
				'label' 	=> esc_html__( 'Taxonomy', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SELECT2,
				'multiple' 	=> false,
				'options' 	=> wcd_get_taxonomies(),
				'default'	=> array_key_first( wcd_get_taxonomies() ),
				'condition' => [
                    'taxonomy_show' => 'yes'
                ],

			]
		);

		$repeater->add_control(
			'taxonomy_repeater_input_type',
			[
				'label' 	=> esc_html__( 'Input Field Type', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SELECT,
				'multiple' 	=> false,
				'options' 	=> [
					'checkbox' =>'Checkbox',
					'radio'    => 'Radio'],
				'default'	=> 'checkbox',
				'condition' => [
                    'taxonomy_show' => 'yes'
                ],
			]
		);

		$repeater->add_control(
			'taxonomy_repeater_view_type',
			[
				'label' 	=> esc_html__( 'View Type', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SELECT,
				'multiple' 	=> false,
				'options' 	=> [
					'default' 	=> 'Default',
					'button'    => 'Button',
					'swatch'	=> 'Swatch'],
				'default'	=> 'default',
				'condition' => [
                    'taxonomy_show' => 'yes'
                ],
			]
		);

		$this->add_control(
			'taxonomy_repeater_items',
			[
				'label' 		=> __( 'Taxonomy List', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> wcd_formated_taxonomy(),
				'title_field' 	=> '{{{ taxonomy_repeater_name }}}',
			]
		);

        $this->add_control(
        	'show_count',
        	[
        		'label'         => __( 'Show Product Count', 'codesigner-pro' ),
        		'type'          => Controls_Manager::SWITCHER,
        		'label_on'      => __( 'Show', 'codesigner-pro' ),
        		'label_off'     => __( 'Hide', 'codesigner-pro' ),
        		'return_value'  => 'yes',
        		'default'       => 'yes',
        	]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'fv_ajax_filter',
			[
				'label' 		=> __( 'AJAX Filter', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'fv_enable_ajax_filter',
			[
				'label'         => __( 'Enable', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => __( 'Yes', 'codesigner-pro' ),
				'label_off'     => __( 'No', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'no',
			]
		);

		$this->add_control(
			'fv_ajax_filter_widget',
			[
				'label' 		=> __( 'Shop Widget', 'codesigner' ),
				'type' 			=> Controls_Manager::SELECT2,
				'multiple' 		=> false,
				'options'		=> wcd_get_shop_options(),
				'label_block' 	=> true,
				'default'       => '',
				'description'	=> __( 'What shop widget are you using with this filter?', 'codesigner' ),
				'condition' 	=> [
                    'fv_enable_ajax_filter' => 'yes'
                ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'fv_section_header',
			[
				'label' 		=> __( 'Header', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'fv_header_show_hide',
			[
				'label'         => __( 'Show Header', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => __( 'Show', 'codesigner-pro' ),
				'label_off'     => __( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'fv_section_header_text',
			[
				'label' => __( 'Heading Text', 'codesigner-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Filter',
				'condition' => [
                    'fv_header_show_hide' => 'yes'
                ],
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'fv_section_form_action',
			[
				'label' 		=> __( 'Form Action', 'codesigner' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'form_action_show',
			[
				'label' 		=> __( 'Form Submits To', 'codesigner' ),
				'type' 			=> Controls_Manager::SELECT2,
				'options'		=> [
					'current'	=> __( 'Current Page', 'codesigner' ),
					'different'	=> __( 'Different Page', 'codesigner' ),
				],
				'default' 		=> 'current',
			]
		);

        $this->add_control(
            'form_action',
            [
                'label'     => __( 'Action URL', 'codesigner' ),
                'type' 	    => Controls_Manager::TEXT,
                'default'	=> get_the_permalink(),
                'placeholder' => get_home_url( null, 'search' ),
				'condition' => [
                    'form_action_show' => 'different'
                ],
            ]
        );

		$this->end_controls_section();

		/*
		*sort_by_show_hide
		*/

		$this->start_controls_section(
			'fv__search',
			[
				'label' 		=> __( 'Search Form', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'filter_vertical_search',
			[
				'label' 		=> __( 'Search', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'codesigner-pro' ),
				'label_off' 	=> __( 'Hide', 'codesigner-pro' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'fv_search_text',
			[
				'label' 	  => __( 'Search Text', 'codesigner-pro' ),
				'type' 		  => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
				'default' 	  => 'Search',
				'condition'   => [
                    'filter_vertical_search' => 'yes'
                ],
			]
		);

		$this->add_control(
			'search_box_icon',
			[
				'label' 	=> __( 'Search Icon', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::ICONS,
				'default' 	=> [
					'value' => 'eicon-search-bold',
					'library' => 'solid',
				],
				'condition'   => [
                    'filter_vertical_search' => 'yes'
                ],
				'separator'		=> 'before'
			]
		);

		$this->end_controls_section();

		
		/*
		*price_by_show_hide
		*/

		$this->start_controls_section(
			'fv_price_by',
			[
				'label' 		=> __( 'Price', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'fv_price_by_show_hide',
			[
				'label'         => __( 'Show Price filter', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => __( 'Show', 'codesigner-pro' ),
				'label_off'     => __( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'fv_price_text',
			[
				'label' 	  => __( 'Price Text', 'codesigner-pro' ),
				'type' 		  => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
				'default' 	  => 'Price',
				'condition'   => [
                    'fv_price_by_show_hide' => 'yes'
                ],
			]
		);

		$this->end_controls_section();
		/*
		*sort_by_show_hide
		*/

		$this->start_controls_section(
			'fv_sort_by',
			[
				'label' 		=> __( 'Sort By', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'fv_sort_by_show_hide',
			[
				'label'         => __( 'Show Sort By filter', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => __( 'Show', 'codesigner-pro' ),
				'label_off'     => __( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'fv_sort_text',
			[
				'label' 	  => __( 'Sort Text', 'codesigner-pro' ),
				'type' 		  => Controls_Manager::TEXT,
				'rows' 		  => 10,
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
				'default' 	  => 'Sort By',
				'condition'   => [
                    'fv_sort_by_show_hide' => 'yes'
                ],
			]
		);

		$this->add_control(
			'fv_sort_items',
			[
				'label' 		=> __( 'Sort Items', 'codesigner' ),
				'type' 			=> Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options'		=> wcd_order_options(),
				'default' 		=> [ 'title', 'name', '_price', 'total_sales' ],
				'label_block' 	=> true,
				'condition' 	=> [
                    'fv_sort_by_show_hide' => 'yes'
                ],
			]
		);

		$this->end_controls_section();

		/*
		*Order_by_show_hide
		*/

		$this->start_controls_section(
			'fv_order',
			[
				'label' 		=> __( 'Order', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'fv_order_show_hide',
			[
				'label'         => __( 'Show order filter', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => __( 'Show', 'codesigner-pro' ),
				'label_off'     => __( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'fv_order_text',
			[
				'label' 	  => __( 'Order Text', 'codesigner-pro' ),
				'type' 		  => Controls_Manager::TEXT,
				'rows' 		  => 10,
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
				'default' 	  => 'Order',
				'condition'   => [
                    'fv_order_show_hide' => 'yes'
                ],
			]
		);

		$this->end_controls_section();
		/*
		*Reviews_show_hide
		*/

		$this->start_controls_section(
			'fv_reviews',
			[
				'label' 		=> __( 'Reviews', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'fv_reviews_show_hide',
			[
				'label'         => __( 'Show Reviews filter', 'codesigner-pro' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on'      => __( 'Show', 'codesigner-pro' ),
				'label_off'     => __( 'Hide', 'codesigner-pro' ),
				'return_value'  => 'yes',
				'default'       => 'yes',
			]
		);

		$this->add_control(
			'fv_reviews_text',
			[
				'label' 	  => __( 'Reviews Text', 'codesigner-pro' ),
				'type' 		  => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
				'default' 	  => 'Average Reviews',
				'condition'   => [
                    'fv_reviews_show_hide' => 'yes'
                ],
			]
		);

		$this->add_control(
			'fv_reviews_after_text',
			[
				'label' 	  => __( 'After star text', 'codesigner-pro' ),
				'type' 		  => Controls_Manager::TEXT,
				'placeholder' => __( 'Type after star text', 'codesigner-pro' ),
				'default' 	  => '& Up',
				'condition'   => [
                    'fv_reviews_show_hide' => 'yes'
                ],
			]
		);

		$this->end_controls_section();

		/*
		*Button show hide and text
		*/

		$this->start_controls_section(
			'_buttons',
			[
				'label' 		=> __( 'Buttons', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'filter_verticle_clear',
			[
				'label' 		=> __( 'Clear Button', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'codesigner-pro' ),
				'label_off' 	=> __( 'Hide', 'codesigner-pro' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
                'separator' 		=> 'before',
			]
		);

		$this->add_control(
			'clear_btn_text',
			[
				'label' 		=> __( 'CLear Button Text', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Clear All', 'codesigner-pro' ),
				'placeholder' 	=> __( 'Type your text here', 'codesigner-pro' ),
				'condition' => [
                    'filter_verticle_clear' => 'yes'
                ],
                'separator' 		=> 'after',
			]
		);

        $this->add_control(
			'filter_verticle_apply',
			[
				'label' 		=> __( 'Apply Button', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'codesigner-pro' ),
				'label_off' 	=> __( 'Hide', 'codesigner-pro' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'apply_btn_text',
			[
				'label' 		=> __( 'Apply Button Text', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Apply', 'codesigner-pro' ),
				'placeholder' 	=> __( 'Type your text here', 'codesigner-pro' ),
				'condition' => [
                    'filter_verticle_apply' => 'yes'
                ],
			]
		);

		$this->end_controls_section();

		/**
		 * Description style Section
		 */
		$this->start_controls_section(
			'fv_header_style',
			[
				'label'			=> __( 'Section Title', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'fv_header_text_align',
			[
				'label' 		=> __( 'Alignment', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left'	=> [
						'title'	=> __( 'Left', 'codesigner-pro' ),
						'icon'	=> 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'codesigner-pro' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'codesigner-pro' ),
						'icon' 	=> 'eicon-text-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors'     => [
					'{{WRAPPER}} .wl-fv-filter-heading' => 'text-align: {{VALUE}}',
				],
				'separator'		=>	'after'
			]
		);

		$this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'filter_verticle_gradient_color',
                'selector' => '{{WRAPPER}} .wl-fv-filter-heading h3',
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'filter_verticle_ypography',
				'label' => __( 'Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-filter-heading h3',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 16 ] ],
		            'font_family' 	=> [ 'default' => 'Montserrat' ],
		            'font_weight' 	=> [ 'default' => 500 ],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'          => 'filter_verticle_border',
				'label'         => __( 'Border', 'codesigner-pro' ),
				'selector'      => '{{WRAPPER}} .wl-fv-filter-heading h3',
				'separator'		=> 'before'
			]
		);

		$this->add_responsive_control(
			'filter_verticle_border_radius',
			[
				'label'         => __( 'Border Radius', 'codesigner-pro' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .wl-fv-filter-heading h3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'filter_verticle_background',
						'label' => __( 'Background', 'codesigner-pro' ),
						'types' => [ 'classic', 'gradient'],
						'selector' => '{{WRAPPER}} .wl-fv-filter-heading',
					]
				);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'filter_verticle_box_shadow',
				'label' => __( 'Box Shadow', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-filter-heading',
			]
		);

		$this->add_responsive_control(
			'fv_field_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-filter-heading h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before',
			]
		);

		$this->add_responsive_control(
			'fv_margin',
			[
				'label' 		=> __( 'Margin', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-filter-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Search Box
		 */
		$this->start_controls_section(
			'filter_vertical_search_box',
			[
				'label'			=> __( 'Search Box', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
                'condition' => [
                    'filter_vertical_search' => 'yes'
                ],
			]
		);

        $this->add_control(
			'search_box_text_color',
			[
				'label' 	=> __( 'Text Color', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-fv-filter-search input' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'search_box_background',
				'label' => __( 'Background', 'codesigner-pro' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .wl-fv-filter-search input',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'search_box_typography',
				'label' => __( 'Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-filter-search input',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 14 ] ],
		            'font_family' 	=> [ 'default' => 'Montserrat' ],
		            'font_weight' 	=> [ 'default' => 400 ],
				],
			]
		);

        $this->add_control(
			'search_box_icon_color',
			[
				'label' 	=> __( 'Icon Color', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-fv-search-button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'          => 'search_box_border',
				'label'         => __( 'Border', 'codesigner-pro' ),
				'selector'      => '{{WRAPPER}} .wl-fv-filter-search input',
				'separator'		=> 'before'
			]
		);

		$this->add_responsive_control(
			'search_box_border_radius',
			[
				'label'         => __( 'Border Radius', 'codesigner-pro' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .wl-fv-filter-search input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'search_box_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-filter-search input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before',
			]
		);

		$this->add_responsive_control(
			'search_box_margin',
			[
				'label' 		=> __( 'Margin', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-filter-search' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Components style Section
		 */
		$this->start_controls_section(
			'fv_component_style',
			[
				'label'			=> __( 'Components', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs( 'filter_component_dropdown_tabs' );

        $this->start_controls_tab(
            'filter_component_dropdown_title',
            [
                'label' => __( 'Dropdown Title', 'codesigner-pro' ),
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'component_typography',
				'label' => __( 'Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-tab-label, .wl-fv-range-value div',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 14 ] ],
		            'font_family' 	=> [ 'default' => 'Montserrat' ],
		            'font_weight' 	=> [ 'default' => 400 ],
				],
			]
		);


		$this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'filter_verticle_comp_gradient_color',
                'selector' => '{{WRAPPER}} .wl-fv-tab-label, {{WRAPPER}} .wl-fv-range-value div span',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_component_dropdown_items',
            [
                'label' => __( 'Dropdown Items', 'codesigner-pro' ),
            ]
        );

        $this->add_control(
			'filter_component_item_color',
			[
				'label' 		=> __( 'Text Color', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-radio-custom-label span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wl-fv-checkbox-custom-label span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'filter_component_item_typography',
				'label' => __( 'Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-radio-custom-label span, .wl-fv-checkbox-custom-label span',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 14 ] ],
		            'font_family' 	=> [ 'default' => 'Montserrat' ],
		            'font_weight' 	=> [ 'default' => 400 ],
				],
			]
		);

		$this->add_responsive_control(
            'filter_component_check_icon_size',
            [
                'label'     	=> __( 'Check Icon Size', 'codesigner-pro' ),
                'type'      	=> Controls_Manager::SLIDER,
                'size_units'	=> [ 'px', 'em' ],
                'selectors' 	=> [
                    '{{WRAPPER}} .wl-fv-checkbox-custom + .wl-fv-checkbox-custom-label::before, .wl-fv-radio-custom + .wl-fv-radio-custom-label::before' => 'width: {{SIZE}}{{UNIT}} !important; height: {{SIZE}}{{UNIT}} !important',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
        	'fv_label_padding',
        	[
        		'label' 		=> __( 'Padding', 'codesigner-pro' ),
        		'type' 			=> Controls_Manager::DIMENSIONS,
        		'size_units' 	=> [ 'px', '%', 'em' ],
        		'selectors' 	=> [
        			'{{WRAPPER}} .wl-fv-tab-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        		],
        		'separator'		=> 'before',
        	]
        );

        $this->add_responsive_control(
        	'fv_label_margin',
        	[
        		'label' 		=> __( 'Margin', 'codesigner-pro' ),
        		'type' 			=> Controls_Manager::DIMENSIONS,
        		'size_units' 	=> [ 'px', '%', 'em' ],
        		'selectors' 	=> [
        			'{{WRAPPER}} .wl-fv-tab-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        		],
        	]
        );

		$this->end_controls_section();
		/**
		 * Reviews style Section 
		 */
		$this->start_controls_section(
			'fv_reviews_style',
			[
				'label'			=> __( 'Reviews', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'reviews_filled_star_color',
			[
				'label' 	=> __( 'Filled Star Color', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-filled-star-color' => 'color: {{VALUE}}',
				],
				'default'	=> '#ffa537'
			]
		);
		$this->add_control(
			'reviews_empty_star_color',
			[
				'label' 	=> __( 'Empty Star Color', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-empty-star-color' => 'color: {{VALUE}}',
				],
				'default'	=> '#ffa537'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'star_typography',
				'label' => __( ' Star Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-star-typography span',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 18 ] ],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'star_after_typography',
				'label' => __( ' Star Text Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-star-typography',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 18 ] ],
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Button style Section wl-fv-btn-checkout
		 */
		$this->start_controls_section(
			'filter_horizontal_apply_button',
			[
				'label'			=> __( 'Apply Button', 'codesigner-pro' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'apply_button_typography',
				'label' => __( 'Typography', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-btn-checkout',
				'fields_options' 	=> [
					'typography' 	=> [ 'default' => 'yes' ],
					'font_size' 	=> [ 'default' => [ 'size' => 14 ] ],
		            'font_family' 	=> [ 'default' => 'Montserrat' ],
		            'font_weight' 	=> [ 'default' => 400 ],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'apply_button_box_shadow',
				'label' => __( 'Box Shadow', 'codesigner-pro' ),
				'selector' => '{{WRAPPER}} .wl-fv-btn-checkout',
				'separator'		=> 'before'
			]
		);

		$this->add_responsive_control(
			'apply_button_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-btn-checkout' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before',
			]
		);

		$this->add_responsive_control(
			'apply_button_margin',
			[
				'label' 		=> __( 'Margin', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-fv-btn-checkout' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs(
            'apply_normal_separator',
            [
                'separator' => 'before'
            ]
        );
        $this->start_controls_tab(
            'apply_btn_normal',
            [
                'label'     => __( 'Normal', 'codesigner-pro' ),
            ]
        );

        $this->add_control(
			'apply_button_text_color',
			[
				'label' 	=> __( 'Text Color', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-fv-btn-checkout' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'apply_button_background',
				'label' => __( 'Background', 'codesigner-pro' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .wl-fv-btn-checkout',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'          => 'apply_button_border',
				'label'         => __( 'Border', 'codesigner-pro' ),
				'selector'      => '{{WRAPPER}} .wl-fv-btn-checkout',				
			]
		);

		$this->add_responsive_control(
			'apply_button_border_radius',
			[
				'label'         => __( 'Border Radius', 'codesigner-pro' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .wl-fv-btn-checkout' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

        $this->start_controls_tab(
            'apply_btn_hover',
            [
                'label'     => __( 'Hover', 'codesigner-pro' ),
            ]
        );

        $this->add_control(
			'apply_button_text_color_hover',
			[
				'label' 	=> __( 'Text Color', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-fv-btn-checkout:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'apply_button_background_hover',
				'label' => __( 'Background', 'codesigner-pro' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .wl-fv-btn-checkout:hover',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'          => 'apply_button_border_hover',
				'label'         => __( 'Border', 'codesigner-pro' ),
				'selector'      => '{{WRAPPER}} .wl-fv-btn-checkout:hover',				
			]
		);

		$this->add_responsive_control(
			'apply_button_border_radius_hover',
			[
				'label'         => __( 'Border Radius', 'codesigner-pro' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .wl-fv-btn-checkout:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}

	protected function render() {

		$settings 			= $this->get_settings_for_display();
		extract( $settings );
		$_sortable_select 		= $settings['taxonomy_repeater_items'];
		$sortable_select_args 	= [];
		foreach ( $_sortable_select as $value ) {
			if ( $value['taxonomy_show'] == 'yes' ) {
				$sortable_select_args[ $value['taxonomy_repeater_name'] ][0]= $value['taxonomy_repeater_select'];
				$sortable_select_args[ $value['taxonomy_repeater_name'] ][1]= $value['taxonomy_repeater_input_type'];
				$sortable_select_args[ $value['taxonomy_repeater_name'] ][2]= $value['taxonomy_repeater_view_type'];
			}
		}

		$currency_symbol 	= function_exists( 'get_woocommerce_currency_symbol' ) ? get_woocommerce_currency_symbol() : '';
		$id 		= $this->get_id();
		$section_id = $this->get_raw_data()['id'];
		$action 	= $form_action_show == 'different' ? $form_action : get_the_permalink();

		/**
		 * Load attributes
		 */
		$this->render_editing_attributes();
		?>

		<div class="wl-fv-filters-area">
			<?php if ( 'yes' == $fv_header_show_hide ): ?>
				<div class="wl-fv-filter-heading-area">
					<div class="wl-fv-filter-heading">

						<?php 
						printf( '<h3 %s>%s</h3>',
				            $this->get_render_attribute_string( 'fv_section_header_text' ),
				            esc_html( $fv_section_header_text ) 
				        );
						?>

					</div>
				</div>
			<?php endif; 

			$form_id = '';
			if ( 'yes' == $fv_enable_ajax_filter ) {
				$form_id = 'wl-ajax-filter-form';
			}
			?>

			<form class="<?php echo esc_attr( $form_id ); ?>" method="get" action="<?php echo esc_url( $action ) ?>">

				<?php 
				if ( 'yes' == $fv_enable_ajax_filter ) {
					echo '<input type="hidden" name="action" value="ajax-filter">';
					echo '<input type="hidden" name="widget_id" value="'. esc_attr( $fv_ajax_filter_widget ) .'">';
					wp_nonce_field( 'codesigner-shop' );
				}
				?>
				
				<div class="wl-fv-filters">

					<?php if ( 'yes' == $filter_vertical_search ): ?>
						<div class="wl-fv-single-filter-search">
							<div class="wl-fv-filter-search">
								<?php  
								$search = isset( $_GET['filter']['q'] ) ? sanitize_text_field( $_GET['filter']['q']  ): ''; 
								?>
								<input type="search" name="filter[q]" value="<?php echo esc_attr( $search ); ?>" placeholder="<?php echo esc_html( $fv_search_text ); ?>">
								<button class="wl-fv-search-button"><i class="<?php echo esc_attr( $search_box_icon['value'] ); ?>"></i></button>
							</div>
						</div>
					<?php endif;

					if( 'yes' == $fv_price_by_show_hide ): ?>
						<div class="wl-fv-single-filter wl-fv-single-filter-<?php esc_attr_e( $section_id ); ?>">
							<input type="checkbox" id="fv-price-<?php echo esc_attr( $id ); ?>" checked>
							<label class="wl-fv-tab-label" for="fv-price-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $fv_price_text ); ?></label>
							<div class="wl-fv-filter-content">
								<div class="wl-fv-price-range-slider">
									<div id="slider-range" class="wl-fv-range-bar"></div>
									<div class="wl-fv-range-value">
										<div class="wl-fv-range-inner">
											<div class="wl-fv-range-input">
												<span class="wl-fv-currency">
													<?php echo esc_html( $currency_symbol ); ?>
												</span>
												<input class="wl-fv-amount" name="filter[min_price]" type="text" id="amount" readonly />
											</div>
											<span class="wl-fv-range-am"><?php esc_html_e( 'Min', 'codesigner-pro' ) ?></span>
										</div>
										<div class="wl-fv-range-inner"> 
											<div class="wl-fv-range-input">
												<span class="wl-fv-currency"><?php echo esc_html( $currency_symbol ); ?></span><input name="filter[max_price]" type="text" id="amax" class="wl-fv-amax" readonly />
											</div>
											<span class="wl-fv-range-am"><?php esc_html_e( 'Max', 'codesigner-pro' ) ?></span>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endif;

					if( 'yes' == $fv_sort_by_show_hide ): ?>
						<div class="wl-fv-single-filter wl-fv-single-filter-<?php esc_attr_e( $section_id ); ?>">
							<input type="checkbox" id="order_vertical-<?php echo esc_attr( $id ); ?>">
							<label class="wl-fv-tab-label" for="order_vertical-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $fv_sort_text ); ?></label>
							<div class="wl-fv-filter-content" style="display: none;">
								<?php
								$sort_options = wcd_order_options();
								foreach ( $sort_options as $key => $sort_option ):
									if ( in_array( $key, $fv_sort_items ) ) {
										$checked = '';
										if ( isset( $_GET['filter']['orderby'] ) && $key == $_GET['filter']['orderby'] ) $checked = 'checked';
										?>	 
										<div>
											<input id="vertical_<?php esc_attr_e( $key ); ?>" 
											class="wl-fv-radio-custom" 
											name="filter[orderby]" type="radio" 
											value="<?php echo esc_attr( $key ); ?>" <?php echo esc_attr( $checked ); ?>>
											<label for="vertical_<?php esc_attr_e( $key ); ?>" class="wl-fv-radio-custom-label">
												<span><?php echo esc_html( $sort_option ); ?></span>
											</label>
										</div>
								<?php } endforeach; ?>
							</div>
						</div>
					<?php endif;

					if( 'yes' == $fv_order_show_hide ): ?>
						<div class="wl-fv-single-filter wl-fv-single-filter-<?php esc_attr_e( $section_id ); ?>">
							<input type="checkbox" id="orderby_vertical-<?php echo esc_attr( $id ); ?>">
							<label class="wl-fv-tab-label" for="orderby_vertical-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $fv_order_text ); ?></label>
							<div class="wl-fv-filter-content" style="display: none;">
								<?php
								$sort_options = array(
									'ASC' 	=> __( 'ASC', 'codesigner-pro' ),
									'DESC' 	=> __( 'DESC', 'codesigner-pro' )
								);
								foreach ( $sort_options as $key => $sort_option ):
									$checked = '';
									if ( isset( $_GET['filter']['order'] ) && $key == $_GET['filter']['order'] ) $checked = 'checked';
									?>	 
									<div>
										<input id="vertical_<?php echo esc_attr( $key ); ?>" 
										class="wl-fv-radio-custom" 
										name="filter[order]" type="radio" 
										value="<?php echo esc_attr( $key ); ?>" <?php echo esc_attr( $checked ); ?>>
										<label for="vertical_<?php echo esc_attr( $key ); ?>" class="wl-fv-radio-custom-label">
											<span><?php echo esc_html( $sort_option ); ?></span>
										</label>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif;

					if( ! empty( $sortable_select_args ) ):
						foreach ( $sortable_select_args as $name => $_taxonomy ) :
							$taxonomy = get_taxonomy( $_taxonomy[0] );
							if ( $_taxonomy[2] == 'default' ) {
								$design_class  = '';
							}
							elseif ( $_taxonomy[2] == 'button' ) {
								$design_class  = 'button-design';
							}
							elseif( $_taxonomy[2] == 'swatch' ){
 								$design_class  = 'swatch-design';
							}
							?>
							<div class="wl-fv-single-filter wl-fv-single-filter-<?php esc_attr_e( $section_id ); ?> <?php esc_attr_e( $_taxonomy[0] ); ?>">
								<input type="checkbox" id="fv-<?php echo esc_attr( $_taxonomy[0] ); ?>">
								<label class="wl-fv-tab-label" for="fv-<?php echo esc_attr( $_taxonomy[0] ); ?>">
									<?php echo esc_html( $name ); ?>
								</label>
								<div class="wl-fv-filter-content <?php esc_attr_e( $design_class ); ?>" style="display: none;">
							<?php

							if ( $_taxonomy[0] == 'product_cat' ) {

								$terms  = get_terms( $_taxonomy[0] );
								get_terms_hierarchical( $terms, 0, 0, $_taxonomy[0], $_taxonomy[1], $show_count );
							}
							else{ 
								$count_html = '';
								$get_terms = get_terms( $_taxonomy[0] );
								foreach ( $get_terms as $term ){
									if ( $show_count == 'yes' ) {
										$count_html = " ($term->count)";
									}
									?>
									<div>
										<?php
										$checked 	= '';
										$color 		= get_term_meta( $term->term_id, 'wl-color' ) ? get_term_meta( $term->term_id, 'wl-color' ) : [0=> '#000000'];
										if( isset( $_GET['filter']['taxonomies'][$_taxonomy[0]] ) && in_array( $term->slug, $_GET['filter']['taxonomies'][$_taxonomy[0]] ) ) $checked = 'checked';
										?>
										<input id="<?php esc_attr_e( $_taxonomy[0] ).'_'. esc_attr_e( $term->slug ); ?>" 
										class="wl-fv-<?php esc_attr_e( $_taxonomy[1] ); ?>-custom" 
										name="filter[taxonomies][<?php esc_attr_e( $taxonomy->name ); ?>][]" 
										type="<?php esc_attr_e( $_taxonomy[1] ); ?>" value="<?php esc_attr_e( $term->slug ); ?>" <?php esc_attr_e( $checked ); ?> >
										<label for="<?php esc_attr_e( $_taxonomy[0] ).'_'. esc_attr_e( $term->slug ); ?>" class="wl-fv-<?php esc_attr_e( $_taxonomy[1] ); ?>-custom-label" >
											<p class="swtch-color" style="background-color:<?php esc_attr_e( $color[0] ); ?>"></p>
											<span><?php echo esc_html( $term->name.$count_html ); ?></span>
										</label>
									</div>
								<?php 
								} 
							}
							?>
							</div>
						</div>
						<?php endforeach; 
					endif;

					if( 'yes' == $fv_reviews_show_hide ): ?>
						<div class="wl-fv-single-filter wl-fv-single-filter-<?php esc_attr_e( $section_id ); ?>">
							<input type="checkbox" id="reviews_vertical-<?php echo esc_attr( $id ); ?>">
							<label class="wl-fv-tab-label" for="reviews_vertical-<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $fv_reviews_text ); ?></label>
							<div class="wl-fv-filter-content" style="display: none;">
								<?php
								$sort_options = array( 4, 3, 2, 1 );
								foreach ( $sort_options as $sort_option ):
									$checked = '';
									if ( isset( $_GET['filter']['reviews'] ) && $sort_option == $_GET['filter']['reviews'] ) $checked = 'checked';
									?>	 
									<div>
										<input id="vertical_<?php echo esc_attr( $sort_option ); ?>" 
										class="wl-fv-radio-custom" 
										name="filter[reviews]" type="radio" 
										value="<?php echo esc_attr( $sort_option ); ?>" <?php echo esc_attr( $checked ); ?>>
										<label for="vertical_<?php echo esc_attr( $sort_option ); ?>" class="wl-fv-radio-custom-label wl-star-typography">
											<?php
											for ( $i = 0; $i < $sort_option ; $i++ ) { 
												?>
												<span><i class="eicon-star wl-filled-star-color"></i></span>
												<?php
											}
											$empty_star = 5 - $sort_option;
											for ( $i = 0; $i < $empty_star ; $i++ ) { 
												?>
												<span><i class="eicon-star-o wl-empty-star-color"></i></span>
												<?php
											}
											?>
											<?php echo esc_html( $fv_reviews_after_text ); ?>
										</label>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
				<div class="wl-fv-flter-action-area">
					<div class="wl-fv-flter-action-left">
						
						<?php 
						if( 'yes' == $filter_verticle_clear ):
							if ( 'yes' == $fv_enable_ajax_filter ) {
								printf( '<button type="submit" class="wl-filter-clear-btn">%s</button>',
						            esc_html( $clear_btn_text ) 
						        );
							}
							else {
								global $wp;							
								printf( '<a %s href="%s">%s</a>',
				            		$this->get_render_attribute_string( 'clear_btn_text' ),
						            home_url( $wp->request ),
						            esc_html( $clear_btn_text ) 
						        );
							}

				        endif; 
				        ?>

					</div>
					<div class="wl-fv-flter-action-right">

						<?php 
						if( 'yes' == $filter_verticle_apply ): 

							printf( '<button %s type="submit">%s</button>',
			            		$this->get_render_attribute_string( 'apply_btn_text' ),
					            esc_html( $apply_btn_text ) 
					        );

				        endif; 
				        ?>

					</div>
				</div>
			</form>
		</div>

		<?php

		do_action( 'codesigner_after_main_content', $this );
		
		/**
		 * Load Script
		 */
		$this->render_script();
	}

	private function render_editing_attributes() {
		$this->add_inline_editing_attributes( 'fv_section_header_text', 'basic' );

		$this->add_inline_editing_attributes( 'clear_btn_text', 'basic' );
		$this->add_render_attribute( 'clear_btn_text', 'class', 'wl-fv-clear-btn' );

		$this->add_inline_editing_attributes( 'apply_btn_text', 'basic' );
		$this->add_render_attribute( 'apply_btn_text', 'class', 'wl-fv-btn-checkout' );
	}

	protected function render_script() {
		$settings 			= $this->get_settings_for_display();
		extract( $settings );
		
		$section_id = $this->get_raw_data()['id'];
		?>

		<script type="text/javascript">
			jQuery(function($){
				var min_price = parseInt( CODESIGNER.min_price )
				var max_price = parseInt( CODESIGNER.max_price )
				$( ".wl-fv-range-bar" ).slider({
					range: true,
					min: min_price,
					max: max_price,
					values: [ CODESIGNER.crnt_min, CODESIGNER.crnt_max ],
					slide: function( event, ui ) {
						$( ".wl-fv-amount" ).val( ui.values[ 0 ] )
						+ $( ".wl-fv-amax" ).val( ui.values[ 1 ] ) ;
					}
				});
				$( ".wl-fv-amount" ).val(  $( ".wl-fv-range-bar" ).slider( "values", 0 ) );
				$( ".wl-fv-amax" ).val(  $( ".wl-fv-range-bar" ).slider( "values", 1 ) );

				$('.wl-fv-single-filter-<?php echo $section_id; ?> > label').click(function(e){
					var $par = $(this).parent()
					console.log($par)
					$('.wl-fv-filter-content',$par).slideToggle()
				})
			})
		</script>

		<?php
	}
}